/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.registries;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TemplatePoolRegistry {
    public static final DeferredRegister<StructureTemplatePool> REGISTRY = DeferredRegister.create((ResourceKey)Registry.f_122884_, (String)"shrines");
    public static final RegistryObject<StructureTemplatePool> ABANDONED_VILLA = new PoolBuilder().setDirectory("abandoned_villa").addSingleTemplate(TemplatePoolRegistry.d("abandoned_villa")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> ABANDONED_WITCH_HOUSE = new PoolBuilder().setDirectory("abandoned_witch_house").addSingleTemplate(TemplatePoolRegistry.d("abandoned_witch_house")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> AZALEA_PAVILION = new PoolBuilder().setDirectory("azalea_pavilion").addSingleTemplate(TemplatePoolRegistry.d("azalea_pavilion")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> BALLOON = new PoolBuilder().setDirectory("balloon").addLegacyTemplate("balloon/balloon_1").addLegacyTemplate("balloon/balloon_2").addLegacyTemplate("balloon/balloon_3").addLegacyTemplate("balloon/balloon_4").addLegacyTemplate("balloon/balloon_5").addLegacyTemplate("balloon/balloon_6").addLegacyTemplate("balloon/balloon_7").addLegacyTemplate("balloon/balloon_rainbow").addLegacyTemplate("balloon/balloon2_1").addLegacyTemplate("balloon/balloon2_2").addLegacyTemplate("balloon/balloon2_3").addLegacyTemplate("balloon/balloon2_4").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> BEES = new PoolBuilder().setDirectory("bees").addSingleTemplate(TemplatePoolRegistry.d("bees")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> END_TEMPLE = new PoolBuilder().setDirectory("end_temple").addSingleTemplate(TemplatePoolRegistry.d("end_temple")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> FLOODED_TEMPLE = new PoolBuilder().setDirectory("flooded_temple").addSingleTemplate(TemplatePoolRegistry.d("flooded_temple")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> GUARDIANS_MEETING = new PoolBuilder().setDirectory("guardian_meeting").addSingleTemplate(TemplatePoolRegistry.d("guardian_meeting")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> HARBOUR = new PoolBuilder().setDirectory("harbour").addSingleTemplate("harbour/start").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> HARBOUR_BUILDINGS = new PoolBuilder().setDirectory("harbour").setFileName("buildings").addSingleTemplate("harbour/buildings/crane/crane_1").addSingleTemplate("harbour/buildings/crane/crane_2").addSingleTemplate("harbour/buildings/houses/house_1").addSingleTemplate("harbour/buildings/warehouses/warehouse_big").addSingleTemplate("harbour/buildings/warehouses/warehouse_small_1").addSingleTemplate("harbour/buildings/warehouses/warehouse_small_2").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> HARBOUR_STREET = new PoolBuilder().setDirectory("harbour").setFileName("street").addSingleTemplate("harbour/street/curve_1").addSingleTemplate("harbour/street/curve_2").addSingleTemplate("harbour/street/cross").addSingleTemplate("harbour/street/straight_1").addSingleTemplate("harbour/street/straight_2").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> HARBOUR_WARE = new PoolBuilder().setDirectory("harbour").setFileName("ware").addSingleTemplate("harbour/ware/ware_1", 2).addSingleTemplate("harbour/ware/ware_2", 2).addSingleTemplate("harbour/ware/ware_3").addSingleTemplate("harbour/ware/ware_4").addSingleTemplate("harbour/ware/ware_5", 2).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> HIGH_TEMPLE = new PoolBuilder().setDirectory("high_temple").addSingleTemplate(TemplatePoolRegistry.d("high_temple")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> JUNGLE_TOWER = new PoolBuilder().setDirectory("jungle_tower").addSingleTemplate(TemplatePoolRegistry.d("jungle_tower")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> LUXURY_VILLA = new PoolBuilder().setDirectory("luxury_villa").addSingleTemplate(TemplatePoolRegistry.d("luxury_villa")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> MAYAN_TEMPLE = new PoolBuilder().setDirectory("mayan_temple").addSingleTemplate("mayan_temple/mayan_temple").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> MINERAL_TEMPLE = new PoolBuilder().setDirectory("mineral_temple").addSingleTemplate(TemplatePoolRegistry.d("mineral_temple")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> OASIS_SHRINE = new PoolBuilder().setDirectory("oasis_shrine").addSingleTemplate(TemplatePoolRegistry.d("oasis_shrine")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> NETHER_PYRAMID = new PoolBuilder().setDirectory("nether_pyramid").addSingleTemplate(TemplatePoolRegistry.d("nether_pyramid")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> NETHER_SHRINE = new PoolBuilder().setDirectory("nether_shrine").addSingleTemplate("nether_shrine/nether_shrine_001").addSingleTemplate("nether_shrine/nether_shrine_002").addSingleTemplate("nether_shrine/nether_shrine_003").addSingleTemplate("nether_shrine/nether_shrine_004").addSingleTemplate("nether_shrine/nether_shrine_005").addSingleTemplate("nether_shrine/nether_shrine_006").addSingleTemplate("nether_shrine/nether_shrine_007").addSingleTemplate("nether_shrine/nether_shrine_008").addSingleTemplate("nether_shrine/nether_shrine_009").addSingleTemplate("nether_shrine/nether_shrine_011").addSingleTemplate("nether_shrine/nether_shrine_sandstone").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> MODERN_VILLA = new PoolBuilder().setDirectory("modern_villa").addSingleTemplate(TemplatePoolRegistry.d("modern_villa")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> ORIENTAL_HUT = new PoolBuilder().setDirectory("oriental_hut").addSingleTemplate(TemplatePoolRegistry.d("oriental_hut")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> ORIENTAL_SANCTUARY = new PoolBuilder().setDirectory("oriental_sanctuary").addSingleTemplate(TemplatePoolRegistry.d("oriental_sanctuary")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> INFESTED_PRISON = new PoolBuilder().setDirectory("infested_prison").addSingleTemplate(TemplatePoolRegistry.d("infested_prison")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> SHRINE_OF_SAVANNA = new PoolBuilder().setDirectory("shrine_of_savanna").addSingleTemplate(TemplatePoolRegistry.d("shrine_of_savanna")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> SMALL_PLAYER_HOUSE = new PoolBuilder().setDirectory("small_player_house").addLegacyTemplate(TemplatePoolRegistry.d("small_player_house")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> SMALL_TEMPLE = new PoolBuilder().setDirectory("small_temple").addSingleTemplate(TemplatePoolRegistry.d("small_temple")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> TALL_PLAYER_HOUSE = new PoolBuilder().setDirectory("tall_player_house").addSingleTemplate("tall_player_house/tall_player_house_1").addSingleTemplate("tall_player_house/tall_player_house_2").addSingleTemplate("tall_player_house/tall_player_house_3").buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> TRADER_HOUSE = new PoolBuilder().setDirectory("trader_house").addSingleTemplate(TemplatePoolRegistry.d("trader_house")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> WATCH_TOWER = new PoolBuilder().setDirectory("watch_tower").addSingleTemplate(TemplatePoolRegistry.d("watch_tower")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> WATER_SHRINE = new PoolBuilder().setDirectory("water_shrine").addSingleTemplate(TemplatePoolRegistry.d("water_shrine")).buildAndRegister();
    public static final RegistryObject<StructureTemplatePool> WORLD_TREE_MANOR = new PoolBuilder().setDirectory("world_tree_manor").addSingleTemplate(TemplatePoolRegistry.d("world_tree_manor")).buildAndRegister();

    @Contract(pure=true)
    @NotNull
    private static String d(String s) {
        return s + "/" + s;
    }

    private static class PoolBuilder {
        private String namespace = "shrines";
        private String directory = "";
        private String fileName = "start_pool";
        private final List<Pair<StructurePoolElement, Integer>> poolElements = new ArrayList<Pair<StructurePoolElement, Integer>>();
        private ResourceLocation fallback = new ResourceLocation("empty");

        private PoolBuilder() {
        }

        private PoolBuilder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        private PoolBuilder setDirectory(String directory) {
            this.directory = directory;
            return this;
        }

        private PoolBuilder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        private PoolBuilder setFallBack(ResourceLocation fallback) {
            this.fallback = fallback;
            return this;
        }

        @Contract(value="_ -> this")
        private PoolBuilder addLegacyTemplate(@NotNull String template) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)new ResourceLocation(this.namespace, template).toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)1));
            return this;
        }

        @Contract(value="_ -> this")
        private PoolBuilder addLegacyTemplate(@NotNull ResourceLocation template) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)template.toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)1));
            return this;
        }

        @Contract(value="_, _ -> this")
        private PoolBuilder addLegacyTemplate(@NotNull ResourceLocation template, int weight) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)template.toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)weight));
            return this;
        }

        @Contract(value="_, _, _, _ -> this")
        private PoolBuilder addLegacyTemplate(@NotNull ResourceLocation template, Holder<StructureProcessorList> structureProcessorList, StructureTemplatePool.Projection projection, int weight) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)template.toString(), structureProcessorList).apply(projection)), (Object)weight));
            return this;
        }

        @Contract(value="_ -> this")
        private PoolBuilder addSingleTemplate(@NotNull String template) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)new ResourceLocation(this.namespace, template).toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)1));
            return this;
        }

        @Contract(value="_, _ -> this")
        private PoolBuilder addSingleTemplate(@NotNull String template, int weight) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)new ResourceLocation(this.namespace, template).toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)weight));
            return this;
        }

        @Contract(value="_ -> this")
        private PoolBuilder addSingleTemplate(@NotNull ResourceLocation template) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)template.toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)1));
            return this;
        }

        @Contract(value="_, _ -> this")
        private PoolBuilder addSingleTemplate(@NotNull ResourceLocation template, int weight) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)template.toString(), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)weight));
            return this;
        }

        @Contract(value="_, _, _, _ -> this")
        private PoolBuilder addSingleTemplate(@NotNull ResourceLocation template, Holder<StructureProcessorList> structureProcessorList, StructureTemplatePool.Projection projection, int weight) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)template.toString(), structureProcessorList).apply(projection)), (Object)weight));
            return this;
        }

        private PoolBuilder addTemplate(StructurePoolElement structurePoolElement, int weight) {
            this.poolElements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)structurePoolElement, (Object)weight));
            return this;
        }

        private RegistryObject<StructureTemplatePool> buildAndRegister() {
            if (this.directory.equals("") && this.fileName.equals("start_pool")) {
                throw new IllegalArgumentException("Either directory or file must be set for Structure Template Pools");
            }
            ResourceLocation id = new ResourceLocation(this.namespace, (String)(this.directory.equals("") ? this.fileName : this.directory + "/" + this.fileName));
            return REGISTRY.register(id.m_135815_(), () -> new StructureTemplatePool(id, this.fallback, this.poolElements));
        }
    }
}

